<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_contact
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.keepalive');
HTMLHelper::_('behavior.formvalidator');

?>
<div class="com-contact__form contact-form">
	<form id="contact-form" action="<?php echo Route::_('index.php'); ?>" method="post" class="form-validate form-horizontal">
		<div class="control-group span4 first">
			<div class="control-label"><?php echo $this->form->getLabel('contact_name'); ?></div>
			<div class="control"><?php echo $this->form->getInput('contact_name'); ?></div>
		</div>	
		<div class="control-group span4">
			<div class="control-label"><?php echo $this->form->getLabel('contact_email'); ?></div>
			<div class="control"><?php echo $this->form->getInput('contact_email'); ?></div>
		</div>		
		<div class="control-group span4">
			<div class="control-label"><?php echo $this->form->getLabel('contact_subject'); ?></div>
			<div class="control"><?php echo $this->form->getInput('contact_subject'); ?></div>
		</div>
		<div class="control-group span12 clear">	
			<div class="control-label"><?php echo $this->form->getLabel('contact_message'); ?></div>
			<div class="control"><?php echo $this->form->getInput('contact_message'); ?></div>
		</div>
		<?php 	if ($this->params->get('show_email_copy')){ ?>
		<div class="control-group span12">	
			<div class="control-label"><?php echo $this->form->getLabel('contact_email_copy'); ?></div>
			<div class="control"><?php echo $this->form->getInput('contact_email_copy'); ?></div>
		</div>
		<?php 	} ?>
		<?php //Dynamically load any additional fields from plugins. ?>
		<?php foreach ($this->form->getFieldsets() as $fieldset): ?>
			  <?php if ($fieldset->name != 'contact'):?>
				   <?php $fields = $this->form->getFieldset($fieldset->name);?>
				   <?php foreach($fields as $field): ?>
						<?php if ($field->hidden): ?>
							 <?php echo $field->input;?>
						<?php else:?>
							 <dt>
								<?php echo $field->label; ?>
								<?php if (!$field->required && $field->type != "Spacer"): ?>
								   <span class="optional"><?php echo JText::_('COM_CONTACT_OPTIONAL');?></span>
								<?php endif; ?>
							 </dt>
							 <dd><?php echo $field->input;?></dd>
						<?php endif;?>
				   <?php endforeach;?>
			  <?php endif ?>
		<?php endforeach;?>
		
		<div class="control-group span12">
			<div class="e-controls">
				<button class="btn button btn-primary validate" type="submit"><?php echo Text::_('COM_CONTACT_CONTACT_SEND'); ?></button>
				<input type="hidden" name="option" value="com_contact">
				<input type="hidden" name="task" value="contact.submit">
				<input type="hidden" name="return" value="<?php echo $this->return_page; ?>">
				<input type="hidden" name="id" value="<?php echo $this->item->slug; ?>">
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</form>
</div>
